using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Data;

namespace IndianHealthService.BMXNet.Tests
{

    /// <summary>
    /// BMX ADO SS^BMX TEST FILE^^~~~~~
    /// 
    /// </summary>
    /// 
     public class CreateUpdateDeleteStandardRows : BmxValidUserTestSuite
    {


         [SetUp]
         public override void Setup()
         {
             base.Setup();
             this.SetupTable();
         }

         public override void SetupTable()
         {
             base.SetupTable();
             this.ClearTable();            
         }

        [Test]
        public void AddRow()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            DataRow row = table.NewRow();
            row["NAME"] = "John";
            row["DATE"] = new DateTime(1970, 10, 10);
            row["NUMBER"] = 8;
            row["NUMBER R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME"], "John");
            Assert.AreEqual(row["DATE"], new DateTime(1970, 10, 10));
        }



        [Test]
        public void UpdateRow()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            DataRow row = table.NewRow();
            row["NAME"] = "John";
            row["DATE"] = new DateTime(1970, 10, 10);
            row["NUMBER"] = 8;
            row["NUMBER R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            row = table.Rows[0];
            row["NAME"]="Fred";
            row["DATE"]= new DateTime(1970, 11, 11);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME"], "Fred");
            Assert.AreEqual(row["DATE"], new DateTime(1970, 11, 11));
        }


        [Test]
        public void DeleteRow()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            DataRow row = table.NewRow();
            row["NAME"] = "John";
            row["DATE"] = new DateTime(1970, 10, 10);
            row["NUMBER"] = 8;
            row["NUMBER R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            row = table.NewRow();
            row["NAME"] = "Jane";
            row["DATE"] = new DateTime(1972, 10, 10);
            row["NUMBER"] = 8;
            row["NUMBER R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(2, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(2, table.Rows.Count);
            row = table.Rows[1];
            Assert.AreEqual(row["NAME"], "Jane");
            row.Delete();

            //TODO: Deleting a row does not remove it ... it still counts.  Assert below fails
            //if 1
            Assert.AreEqual(2, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME"],"John");
            
        }





    }
}
